import java.util.Random;

public class Engine {

	Polje kombinacija[] = new Polje[4];
	Polje pokusaji[][] = new Polje[6][4];
	Polje pogodjeni[][] = new Polje[6][4];
	Polje ponudjeni[] = new Polje[6];
	int redKojiSeObradjuje;
	int elementKojiSeObradjuje;
	boolean pogodjeno = false;
	
	public Engine() {
		for (int i = 0; i < kombinacija.length; i++) {
			kombinacija[i] = new Polje(i);
		}
		for (int i = 0; i < 6; i++) {
			for (int j = 0; j < 4; j++) {
				pokusaji[i][j] = new Polje(i, j);
				pogodjeni[i][j] = new Polje(i, j);
			}
		}
		for (int i = 0; i < 6; i++) {
			ponudjeni[i] = new Polje(i);
		}
		
		inicijalizuj();
		napraviKombinaciju();
	}

	public void napraviKombinaciju() {
		Random r = new Random();
		kombinacija[0].indexSlike = r.nextInt(6);
		kombinacija[1].indexSlike = r.nextInt(6);
		kombinacija[2].indexSlike = r.nextInt(6);
		kombinacija[3].indexSlike = r.nextInt(6);
		
		System.out.println("KOMBINACIJA JE: " + kombinacija[0].indexSlike + " " + kombinacija[1].indexSlike + " " + kombinacija[2].indexSlike + " " + kombinacija[3].indexSlike + " "); 
		
	}

	public void inicijalizuj() {
		
		for (int i = 0; i < kombinacija.length; i++) {
			kombinacija[i].indexSlike = -1;
			kombinacija[i].slika = "";
		}
		
		for (int i = 0; i < 6; i++) {
			for (int j = 0; j < 4; j++) {
				pokusaji[i][j].indexSlike = -1;
				pogodjeni[i][j].indexSlike = -1;
				pokusaji[i][j].slika = "";
				pogodjeni[i][j].slika = "";
			}
		}
		redKojiSeObradjuje = 0;
		elementKojiSeObradjuje = 0;
		pogodjeno = false;
	}
	
	public boolean proveraReda() {
		for (int i = 0; i < kombinacija.length; i++) {
			if(pokusaji[redKojiSeObradjuje][i].indexSlike == -1) {
				return false;
			}
		}
		
		
		int brCrvenih = 0;
		int brZutih = 0;
		
		for (int i = 0; i < kombinacija.length; i++) {
			if(pokusaji[redKojiSeObradjuje][i].indexSlike == kombinacija[i].indexSlike) {
				brCrvenih++;
			}
		}
		
		
		for (int i = 0; i < kombinacija.length; i++) {
			for (int j = 0; j < kombinacija.length; j++) {
				if(kombinacija[j].pregledan == false) {
					if(kombinacija[j].indexSlike == pokusaji[redKojiSeObradjuje][i].indexSlike) {
						brZutih++;
						kombinacija[j].pregledan = true;
						break;
					}
				}
			}
		}
		
		// 3 0 0 1 komb
		// 3 1 0 0 pokusaj
		// | | | 
		
		//System.out.println("brCrvwenih: " + brCrvenih + ", brzUTIH: " + brZutih);
		
		brZutih -= brCrvenih;
		if(brCrvenih == 4) {
			pogodjeno = true;
		}
		
		for (int i = 0; i < kombinacija.length; i++) {
			if(brCrvenih > 0) {
				pogodjeni[redKojiSeObradjuje][i].indexSlike = 6;
				brCrvenih--;
			}
		}
		
		for (int i = 0; i < kombinacija.length; i++) {
			if(brZutih > 0 && pogodjeni[redKojiSeObradjuje][i].indexSlike != 6) {
				pogodjeni[redKojiSeObradjuje][i].indexSlike = 7;
				brZutih--;
			}
		}
		
		for (int i = 0; i < kombinacija.length; i++) {
			kombinacija[i].pregledan = false;
		}
		
		redKojiSeObradjuje++;
		return true;
	}
	
	public void popuniPolje(int indexSlike) {
		if(elementKojiSeObradjuje == 4) {
			elementKojiSeObradjuje = 0;
		}
		if(pokusaji[redKojiSeObradjuje][elementKojiSeObradjuje].indexSlike == -1) {
			pokusaji[redKojiSeObradjuje][elementKojiSeObradjuje].indexSlike = indexSlike;
			elementKojiSeObradjuje++;
		}
		
	}
}












